//if(typeof jQuery.browser == "undefined" ){
// Limit scope pollution from any deprecated API
(function() {

    var matched, browser;

// Use of jQuery.browser is frowned upon.
// More details: http://api.jquery.com/jQuery.browser
// jQuery.uaMatch maintained for back-compat
    jQuery.uaMatch = function( ua ) {
        ua = ua.toLowerCase();

        var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
            /(webkit)[ \/]([\w.]+)/.exec( ua ) ||
            /(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
            /(msie) ([\w.]+)/.exec( ua ) ||
            ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
            [];

        return {
            browser: match[ 1 ] || "",
            version: match[ 2 ] || "0"
        };
    };

    matched = jQuery.uaMatch( navigator.userAgent );
    browser = {};

    if ( matched.browser ) {
        browser[ matched.browser ] = true;
        browser.version = matched.version;
    }

// Chrome is Webkit, but Webkit is also Safari.
    if ( browser.chrome ) {
        browser.webkit = true;
    } else if ( browser.webkit ) {
        browser.safari = true;
    }

    jQuery.browser2 = browser;

    jQuery.sub = function() {
        function jQuerySub( selector, context ) {
            return new jQuerySub.fn.init( selector, context );
        }
        jQuery.extend( true, jQuerySub, this );
        jQuerySub.superclass = this;
        jQuerySub.fn = jQuerySub.prototype = this();
        jQuerySub.fn.constructor = jQuerySub;
        jQuerySub.sub = this.sub;
        jQuerySub.fn.init = function init( selector, context ) {
            if ( context && context instanceof jQuery && !(context instanceof jQuerySub) ) {
                context = jQuerySub( context );
            }

            return jQuery.fn.init.call( this, selector, context, rootjQuerySub );
        };
        jQuerySub.fn.init.prototype = jQuerySub.fn;
        var rootjQuerySub = jQuerySub(document);
        return jQuerySub;
    };

})();
//}

/*jslint white: true, indent: 2, onevar: false, browser: true, undef: true, nomen: false, eqeqeq: true, plusplus: false, bitwise: true, regexp: true, strict: false, newcap: true, immed: true */
/*global window, console, jQuery, setTimeout */

/*
 Plugin: iframe autoheight jQuery Plugin
 Version: 1.9.1
 Author and Contributors
 ========================================
 NATHAN SMITH (http://sonspring.com/)
 Jesse House (https://github.com/house9)
 aaron manela (https://github.com/aaronmanela)
 Hideki Abe (https://github.com/hideki-a)
 Patrick Clark (https://github.com/hellopat)
 ChristineP2 (https://github.com/ChristineP2)
 Mmjavellana (https://github.com/Mmjavellana)
 yiqing-95 (https://github.com/yiqing-95)
 jcaspian (https://github.com/jcaspian)
 adamjgray (https://github.com/adamjgray)
 Jens Bissinger (https://github.com/dpree)

 File: jquery.iframe-auto-height.plugin.js
 Remarks: original code from http://sonspring.com/journal/jquery-iframe-sizing
 Description: when the page loads set the height of an iframe based on the height of its contents
 see README: http://github.com/house9/jquery-iframe-auto-height

 */
(function ($) {
    $.fn.iframeAutoHeight = function (spec) {

        var undef;
        if ($.browser2 === undef) {
            var message = [];
            message.push("WARNING: you appear to be using a newer version of jquery which does not support the $.browser2 variable.");
            message.push("The jQuery iframe auto height plugin relies heavly on the $.browser2 features.");
            message.push("Install jquery-browser: https://raw.github.com/jquery/jquery-browser/master/src/jquery.browser.js");
            alert(message.join("\n"));
            return $;
        }

        // set default option values
        var options = $.extend({
            heightOffset: 0,
            minHeight: 0,
            callback: function (newHeight) {},
            animate: false,
            debug: false,
            diagnostics: false, // used for development only
            resetToMinHeight: false,
            triggerFunctions: [],
            heightCalculationOverrides: []
        }, spec);

        // logging
        function debug(message) {
            if (options.debug && options.debug === true && window.console) {
                console.log(message);
            }
        }

        // not used by production code
        function showDiagnostics(iframe, calledFrom) {
            debug("Diagnostics from '" + calledFrom + "'");
            try {
                debug("  " + $(iframe, window.top.document).contents().find('body')[0].scrollHeight + " for ...find('body')[0].scrollHeight");
                debug("  " + $(iframe.contentWindow.document).height() + " for ...contentWindow.document).height()");
                debug("  " + $(iframe.contentWindow.document.body).height() + " for ...contentWindow.document.body).height()");
            } catch (ex) {
                // ie fails when called during for each, ok later on
                // probably not an issue if called in a document ready block
                debug("  unable to check in this state");
            }
            debug("End diagnostics -> results vary by browser and when diagnostics are requested");
        }

        // show all option values
        debug(options);

        // ******************************************************
        // iterate over the matched elements passed to the plugin ; return will make it chainable
        return this.each(function () {

            // ******************************************************
            // http://api.jquery.com/jQuery.browser/
            var strategyKeys = ['webkit', 'mozilla', 'msie', 'opera'];
            var strategies = [];
            strategies['default'] = function (iframe, $iframeBody, options, browser) {
                // NOTE: this is how the plugin determines the iframe height, override if you need custom
                JQuery($iframeBody[0]).css('height', 'auto');
                return $iframeBody[0].scrollHeight + options.heightOffset;
            };
            strategies['webkit'] = function (iframe, $iframeBody, options, browser) {
                // NOTE: this is how the plugin determines the iframe height, override if you need custom
                var f = $(iframe).get(0);
                var y = f.contentWindow;
                JQuery(y.document.body).css('height', 'auto');
                return y.document.body.offsetHeight + options.heightOffset;
            };

            jQuery.each(strategyKeys, function (index, value) {
                // use the default strategy for all browsers, can be overridden if desired
                if(value == 'webkit'){
                    strategies[value] = strategies['webkit'];
                }else{
                    strategies[value] = strategies['default'];
                }
            });

            // override strategies if registered in options
            jQuery.each(options.heightCalculationOverrides, function (index, value) {
                strategies[value.browser] = value.calculation;
            });

            function findStrategy(browser) {
                var strategy = null;

                jQuery.each(strategyKeys, function (index, value) {
                    if (browser[value]) {
                        strategy = strategies[value];
                        return false;
                    }
                });

                if (strategy === null) {
                    strategy = strategies['default'];
                }

                return strategy;
            }
            // ******************************************************

            // for use by webkit only
            var loadCounter = 0;

            // resizeHeight
            function resizeHeight(iframe) {
                if (options.diagnostics) {
                    showDiagnostics(iframe, "resizeHeight");
                }

                // set the iframe size to minHeight so it'll get smaller on resizes in FF and IE
                if (options.resetToMinHeight && options.resetToMinHeight === true) {
                    iframe.style.height = options.minHeight + 'px';
                }

                // get the iframe body height and set inline style to that plus a little
                var $body = $(iframe, window.top.document).contents().find('body');
                var strategy = findStrategy($.browser2);
                var newHeight = strategy(iframe, $body, options, $.browser2);
                debug(newHeight);

                if (newHeight < options.minHeight) {
                    debug("new height is less than minHeight");
                    newHeight = options.minHeight + options.heightOffset;
                }

                debug("New Height: " + newHeight);
                if (options.animate) {
                    $(iframe).animate({height: newHeight + 'px'}, {duration: 500});
                } else {
                    $(iframe).css('height', newHeight + 'px');
                }

                options.callback.apply($(iframe), [{newFrameHeight: newHeight}]);
            } // END resizeHeight

            // debug me
            debug(this);
            if (options.diagnostics) {
                showDiagnostics(this, "each iframe");
            }

            // if trigger functions are registered, invoke them
            if (options.triggerFunctions.length > 0) {
                debug(options.triggerFunctions.length + " trigger Functions");
                for (var i = 0; i < options.triggerFunctions.length; i++) {
                    options.triggerFunctions[i](resizeHeight, this);
                }
            }

            // Check if browser is Webkit (Safari/Chrome) or Opera
            if ($.browser2.webkit || $.browser2.opera) {
                debug("browser is webkit or opera");

                // Start timer when loaded.
                $(this).load(function () {
                    var delay = 0;
                    var iframe = this;

                    var _item = function(){
                        resizeHeight(iframe);
                    };

                    var delayedResize = function () {
                        setInterval(_item, 100);
                    };

                    if (loadCounter === 0) {
                        // delay the first one
                        delay = 50;
                    } else {
                        // Reset iframe height to 0 to force new frame size to fit window properly
                        // this is only an issue when going from large to small iframe, not executed on page load
                        iframe.style.height = options.minHeight + 'px';
                    }

                    debug("load delay: " + delay);
                    setTimeout(delayedResize, delay);
                    loadCounter++;
                });

                // Safari and Opera need a kick-start.
                var source = $(this).attr('src');
                $(this).attr('src', '');
                $(this).attr('src', source);
            } else {
                var _this = this;
                var _item = function(){
                    resizeHeight(_this);
                };
                // For other browsers.
                $(this).load(function () {
                    setInterval(_item, 100);
                });
            } // if browser

        }); // $(this).each(function () {
    }; // $.fn.iframeAutoHeight = function (options) {
}(JQuery)); // (function ($) {